% SMAS estimation of price stickiness as in Guerron-Quintana et al. (2017)
% model

clear all;
load('sampledataT232');
rng('default')
rng('shuffle')

%dynare dgp;

sampledata = sampledataT232(:, :, :);
[d, T, s] = size(sampledata);

B = 1000;
valid = 0;

global p h;
p = 2;
h = 20;
hs = 1;
true_alpha=0.75;

v_est_alpha = zeros(B, 1);
v_est_alpha_reg = zeros(B, 1);
v_est_alpha_nonreg = zeros(B, 1);
v_est_alpha_opt_reg = zeros(B, 1);
v_est_alpha_opt_nonreg = zeros(B, 1);
v_est_alpha_opt = zeros(B, 1);
v_est_alpha_diag = zeros(B, 1);
v_pick_c_1 = zeros(B, 1);
v_pick_c_2 = zeros(B, 1);

% set the range of grid search
alphas = 0.005:0.005:0.995;

% vector of candidate alpha values
c_a = [2 1 0.5 0.1 0.05 0.01 0.005 0.001 0.0001];

N = 199;
trainingT = round(2/3*T);
training = sampledata(:, 1:trainingT, :);
testing = sampledata(:, trainingT+1:T, :);
ST = ceil(0.75*(T^(1/3)));
ST_training = ceil(0.75*(trainingT^(1/3)));

% estimate with training sample
for i = 1:s
    aaa = i
    valid
    if valid < B
    try % if anything wrong, skip to next sample
    % training irf
    v_sampledata = training(:, :, i);
    %solve for a VAR(p) model
    [A,SIGMA,U,V] = olsvarc(v_sampledata', p);
    sampleirf = vec(irfvar(A,SIGMA,p)); % structural irfs generated for this simulated path with true alpha, not vectorized
    
    %testing irf
    v_sampletest = testing(:, :, i);
    [At,SIGMAt,Ut,Vt] = olsvarc(v_sampletest', p);
    testirf = vec(irfvar(At,SIGMAt,p));

    %full sample irf
    v_sampledata_full = sampledata(:, :, i); 
    [Af,SIGMAf,Uf,Vf] = olsvarc(v_sampledata_full', p);
    sampleirf_full = vec(irfvar(Af,SIGMAf,p));

    irf_star = zeros(4, (h+1), N);
    irf_star_1a = zeros(4, (h+1), N);
    irf_star_1b = zeros(4, (h+1), N);
    irf_star_2a = zeros(4, (h+1), N);
    irf_star_2b = zeros(4, (h+1), N);
    irf_star_3a = zeros(4, (h+1), N);
    irf_star_3b = zeros(4, (h+1), N);
    irf_star_4a = zeros(4, (h+1), N);
    irf_star_4b = zeros(4, (h+1), N);
    irf_star_5a = zeros(4, (h+1), N);
    irf_star_5b = zeros(4, (h+1), N);
    v_irf_star = zeros(4*(h+1), N);
    for n = 1:N
%         [IRFii]=bootirf(A,U,v_sampledata',V);
        [IRFii IRFii_ST]=bootirf_opt(A,U,v_sampledata',V,ST_training);
        irf_star(:, :, n) = IRFii;% store the values
        irf_star_1a(:,:,n) = IRFii_ST(:,:,1);
        irf_star_1b(:,:,n) = IRFii_ST(:,:,2);
        irf_star_2a(:,:,n) = IRFii_ST(:,:,3);
        irf_star_2b(:,:,n) = IRFii_ST(:,:,4);
        irf_star_3a(:,:,n) = IRFii_ST(:,:,5);
        irf_star_3b(:,:,n) = IRFii_ST(:,:,6);
        irf_star_4a(:,:,n) = IRFii_ST(:,:,7);
        irf_star_4b(:,:,n) = IRFii_ST(:,:,8);
        irf_star_5a(:,:,n) = IRFii_ST(:,:,9);
        irf_star_5b(:,:,n) = IRFii_ST(:,:,10);
        v_irf_star(:, n) = vec(IRFii);
    end
    
    mean_irf_star = mean(v_irf_star, 2); % calculate the mean of irf from N paths
    demean_irf_star = irf_star-mean(irf_star,3);
    demean_irf_star_1a = irf_star_1a-mean(irf_star_1a,3);
    demean_irf_star_1b = irf_star_1b-mean(irf_star_1b,3);
    demean_irf_star_2a = irf_star_2a-mean(irf_star_2a,3);
    demean_irf_star_2b = irf_star_2b-mean(irf_star_2b,3);
    demean_irf_star_3a = irf_star_3a-mean(irf_star_3a,3);
    demean_irf_star_3b = irf_star_3b-mean(irf_star_3b,3);
    demean_irf_star_4a = irf_star_4a-mean(irf_star_4a,3);
    demean_irf_star_4b = irf_star_4b-mean(irf_star_4b,3);
    demean_irf_star_5a = irf_star_5a-mean(irf_star_5a,3);
    demean_irf_star_5b = irf_star_5b-mean(irf_star_5b,3);
    
    C = zeros(N, N);
    C_opt = zeros(N, N);
        
    for b = 1:N
        for bprime = 1:N
            Cbb = 0;
            Cbb_opt = 0;
            for ss = hs: h
                Cbb = Cbb + demean_irf_star(:, ss+1, b)'* demean_irf_star(:, ss+1, bprime)/N;
                Cbb_opt = Cbb_opt...
                    + (demean_irf_star(:, ss+1, b)'* demean_irf_star(:, ss+1, bprime)...
                    + 2*((1-1/ST_training)*demean_irf_star_1a(:,ss+1,b)'*demean_irf_star_1b(:,ss+1,bprime)...
                        +(1-2/ST_training)*demean_irf_star_2a(:,ss+1,b)'*demean_irf_star_2b(:,ss+1,bprime)...
                        +(1-3/ST_training)*demean_irf_star_3a(:,ss+1,b)'*demean_irf_star_3b(:,ss+1,bprime)...
                        +(1-4/ST_training)*demean_irf_star_4a(:,ss+1,b)'*demean_irf_star_4b(:,ss+1,bprime)...
                        +(1-5/ST_training)*demean_irf_star_5a(:,ss+1,b)'*demean_irf_star_5b(:,ss+1,bprime)))/N;
            end
            C(b, bprime) = Cbb;
            C_opt(b, bprime) = Cbb_opt;
        end
    end
    
    [Beta lambda] = eig(C);
    [Beta_opt lambda_opt] = eig(C_opt);
    
    psi = v_irf_star((4*hs + 1):4*(h+1), :) - mean_irf_star((4*hs+1):4*(h+1));
    phi = psi * Beta/N;
    % normalize phi
    phi = (phi'./sqrt(diag(phi' * phi)))';
    
    psi_opt = demean_irf_star+2*((1-1/ST_training)*demean_irf_star_1a...
                            +(1-2/ST_training)*demean_irf_star_2a...
                            +(1-3/ST_training)*demean_irf_star_3a...
                            +(1-4/ST_training)*demean_irf_star_4a...
                            +(1-5/ST_training)*demean_irf_star_5a);
    psi_opt = reshape(psi_opt, 4*(h+1), N);
    psi_opt = psi_opt((4*hs + 1):4*(h+1), :);
    phi_opt = psi_opt * Beta_opt/N;
    % normalize phi
    phi_opt = (phi_opt'./sqrt(diag(phi_opt' * phi_opt)))';
    
    irfs = zeros(4*(h+1), length(alphas));
    first_time = 1;

    for m=1:length(alphas)
%       try
        if first_time
        
            dynare dgptest noclearall;
            [sim_array]=get_simul_replications(M_,options_); 
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
            first_time = 0;
        else
            set_param_value('alpha',alphas(m));
            [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
            [sim_array]=get_simul_replications(M_,options_);
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
        end
        
        simdata = sim_array([1 2],1001:(1000 + trainingT), :);
        
        m_irf_path = zeros(4*(h+1), 10);
        count = 1;
        j = 1;
            
            while count < 11
                try
                simdata_path = simdata(:, :, j);% extract one path
                [Apath,SIGMApath,Upath,Vpath] = olsvarc(simdata_path', p);
                [IRFr]=bootirf(Apath,U,v_sampledata',Vpath);
                % to construct irfs with residual bootstrapping, we use
                % estimation of Vpath(intercept) and Apath(coefficient
                % matrix) using simulation with selected value of alpha
                % U(residuals) computed from true data
                % initial values are randomly chosen from true data
                irf_path = vec(IRFr); %vectorize IRFr
                m_irf_path(:, count) = irf_path;% store the values
                count = count + 1;
                catch
                    count = count;
                end
                j = j+1;
            end

        mean_irf = sum(m_irf_path, 2)/10; % calculate the mean of ir by the third dimension, with each alpha
        irfs(:, m) = mean_irf; % store the values, as irfs for the alpha

    end
    
    dis = sampleirf((4*hs+1):4*(h+1)) - irfs((4*hs+1):4*(h+1), :); 
    dis_sqr = sum(dis.^2, 1);
    % loop over reg_a's.
    % get values of the objective function associated with each reg_a
    
    reg_a = c_a./(trainingT^(1/3));
    v_obj = zeros(length(alphas), 1);
    v_d_sqr_1 = zeros(length(reg_a), 1);
    
    v_obj_opt = zeros(length(alphas), 1);
    v_d_sqr_2 = zeros(length(reg_a), 1);
    
    for aa = 1:length(reg_a)
        for m = 1: length(alphas)
            reg_dis = dis(:, m);
            reg_sqr = (phi' * reg_dis).^2; % T by 1 vector
            obj = (diag(lambda)./(diag(lambda).^2 + reg_a(aa)))' * reg_sqr;
            v_obj(m) = obj;
            
            reg_sqr_opt = (phi_opt' * reg_dis).^2; % T by 1 vector
            obj_opt = (diag(lambda_opt)./(diag(lambda_opt).^2 + reg_a(aa)))' * reg_sqr_opt;
            v_obj_opt(m) = obj_opt;
        end
% diagonal SMAS    
        est_alpha_reg = alphas*(v_obj == min(v_obj));

        set_param_value('alpha',est_alpha_reg); % update alpha, get the simulation
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));

        simtesting = sim_array([1 2],(1001+trainingT):(1000+T), randi([1 500],1));
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting', p);
            
        m_irf_testing_1 = zeros(4*(h+1), 10);

            for tt = 1:10
                [IRFt1]=bootirf(Atest,Ut,v_sampletest',Vtest);
                m_irf_testing_1(:, tt) = vec(IRFt1);% store the values
            end

        mean_irf_testing_1 = mean(m_irf_testing_1,2);
        d_sqr_1 = (testirf((4*hs+1):4*(h+1)) - mean_irf_testing_1((4*hs+1):4*(h+1)))'...
            *(testirf((4*hs+1):4*(h+1)) - mean_irf_testing_1((4*hs+1):4*(h+1)));
        v_d_sqr_1(aa) = d_sqr_1;
 % optimal SMAS
        est_alpha_reg_opt = alphas*(v_obj_opt == min(v_obj_opt));

        set_param_value('alpha',est_alpha_reg_opt); % update alpha, get the simulation
        [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
        [sim_array]=get_simul_replications(M_,options_);
        y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));

        simtesting = sim_array([1 2],(1001+trainingT):(1000+T), randi([1 500],1));
        [Atest,SIGMAtest,Utest,Vtest] = olsvarc(simtesting', p);
            
        m_irf_testing_2 = zeros(4*(h+1), 10);

            for tt = 1:10
                [IRFt2]=bootirf(Atest,Ut,v_sampletest',Vtest);
                m_irf_testing_2(:, tt) = vec(IRFt2);% store the values
            end

        mean_irf_testing_2 = mean(m_irf_testing_2,2);
        d_sqr_2 = (testirf((4*hs+1):4*(h+1)) - mean_irf_testing_2((4*hs+1):4*(h+1)))'...
            *(testirf((4*hs+1):4*(h+1)) - mean_irf_testing_2((4*hs+1):4*(h+1)));
        v_d_sqr_2(aa) = d_sqr_2;
    end
    
    pick_c_1 = c_a*(v_d_sqr_1 == min(v_d_sqr_1));
    v_pick_c_1(i) = pick_c_1;
    
    pick_c_2 = c_a*(v_d_sqr_2 == min(v_d_sqr_2));
    v_pick_c_2(i) = pick_c_2;
    
    irf_star_full = zeros(4, (h+1), N);
    irf_star_full_1a = zeros(4, (h+1), N);
    irf_star_full_1b = zeros(4, (h+1), N);
    irf_star_full_2a = zeros(4, (h+1), N);
    irf_star_full_2b = zeros(4, (h+1), N);
    irf_star_full_3a = zeros(4, (h+1), N);
    irf_star_full_3b = zeros(4, (h+1), N);
    irf_star_full_4a = zeros(4, (h+1), N);
    irf_star_full_4b = zeros(4, (h+1), N);
    irf_star_full_5a = zeros(4, (h+1), N);
    irf_star_full_5b = zeros(4, (h+1), N);
    v_irf_star_full = zeros(4*(h+1), N);
    
    for n = 1:N
%         [IRFfull]=bootirf(Af,Uf,v_sampledata_full',Vf);
        [IRFfull IRFfull_ST]=bootirf_opt(Af,Uf,v_sampledata_full',Vf,ST);
        irf_star_full(:, :, n) = IRFfull;% store the values
        irf_star_full_1a(:,:,n) = IRFfull_ST(:,:,1);
        irf_star_full_1b(:,:,n) = IRFfull_ST(:,:,2);
        irf_star_full_2a(:,:,n) = IRFfull_ST(:,:,3);
        irf_star_full_2b(:,:,n) = IRFfull_ST(:,:,4);
        irf_star_full_3a(:,:,n) = IRFfull_ST(:,:,5);
        irf_star_full_3b(:,:,n) = IRFfull_ST(:,:,6);
        irf_star_full_4a(:,:,n) = IRFfull_ST(:,:,7);
        irf_star_full_4b(:,:,n) = IRFfull_ST(:,:,8);
        irf_star_full_5a(:,:,n) = IRFfull_ST(:,:,9);
        irf_star_full_5b(:,:,n) = IRFfull_ST(:,:,10);
        
        v_irf_star_full(:, n) = vec(IRFfull);
    end

    mean_irf_star_full = mean(v_irf_star_full, 2); % calculate the mean of irf from N paths
    demean_irf_star_full = irf_star_full-mean(irf_star_full,3);

    demean_irf_star_full_1a = irf_star_full_1a-mean(irf_star_full_1a,3);
    demean_irf_star_full_1b = irf_star_full_1b-mean(irf_star_full_1b,3);
    demean_irf_star_full_2a = irf_star_full_2a-mean(irf_star_full_2a,3);
    demean_irf_star_full_2b = irf_star_full_2b-mean(irf_star_full_2b,3);
    demean_irf_star_full_3a = irf_star_full_3a-mean(irf_star_full_3a,3);
    demean_irf_star_full_3b = irf_star_full_3b-mean(irf_star_full_3b,3);
    demean_irf_star_full_4a = irf_star_full_4a-mean(irf_star_full_4a,3);
    demean_irf_star_full_4b = irf_star_full_4b-mean(irf_star_full_4b,3);
    demean_irf_star_full_5a = irf_star_full_5a-mean(irf_star_full_5a,3);
    demean_irf_star_full_5b = irf_star_full_5b-mean(irf_star_full_5b,3);
    
    Cf = zeros(N, N);
    Cf_opt = zeros(N, N);    
    for b = 1:N
        for bprime = 1:N
            Cbb_f = 0;
            Cbb_f_opt = 0;
            for ss = hs: h
                Cbb_f = Cbb_f + demean_irf_star_full(:, ss+1, b)'...
                    * demean_irf_star_full(:, ss+1, bprime)/N;
                Cbb_f_opt = Cbb_f_opt...
                    + (demean_irf_star_full(:, ss+1, b)'* demean_irf_star_full(:, ss+1, bprime)...
                    + 2*((1-1/ST)*demean_irf_star_full_1a(:,ss+1,b)'*demean_irf_star_full_1b(:,ss+1,bprime)...
                        +(1-2/ST)*demean_irf_star_full_2a(:,ss+1,b)'*demean_irf_star_full_2b(:,ss+1,bprime)...
                        +(1-3/ST)*demean_irf_star_full_3a(:,ss+1,b)'*demean_irf_star_full_3b(:,ss+1,bprime)...
                        +(1-4/ST)*demean_irf_star_full_4a(:,ss+1,b)'*demean_irf_star_full_4b(:,ss+1,bprime)...
                        +(1-5/ST)*demean_irf_star_full_5a(:,ss+1,b)'*demean_irf_star_full_5b(:,ss+1,bprime)))/N;
            end
            Cf(b, bprime) = Cbb_f;
            Cf_opt(b, bprime) = Cbb_f_opt;
        end
    end
    
    [Beta_f lambda_f] = eig(Cf); 
    [Beta_f_opt lambda_f_opt] = eig(Cf_opt);

    psi_f = v_irf_star_full((4*hs+1):4*(h+1), :) - mean_irf_star_full((4*hs+1):4*(h+1));
    phi_f = psi_f * Beta_f/N;
    phi_f = (phi_f'./sqrt(diag(phi_f' * phi_f)))';
    
    psi_f_opt = demean_irf_star_full+2*((1-1/ST)*demean_irf_star_full_1a...
                            +(1-2/ST)*demean_irf_star_full_2a...
                            +(1-3/ST)*demean_irf_star_full_3a...
                            +(1-4/ST)*demean_irf_star_full_4a...
                            +(1-5/ST)*demean_irf_star_full_5a);
    psi_f_opt = reshape(psi_f_opt, 4*(h+1), N);
    psi_f_opt = psi_f_opt((4*hs + 1):4*(h+1), :);
    phi_f_opt = psi_f_opt * Beta_f_opt/N;
    % normalize phi
    phi_f_opt = (phi_f_opt'./sqrt(diag(phi_f_opt' * phi_f_opt)))';
    
    W_opt_inv = (mean_irf_star_full((4*hs + 1): 4*(h+1)) - v_irf_star_full((4*hs + 1): 4*(h+1), :))...
        *(mean_irf_star_full((4*hs + 1): 4*(h+1)) - v_irf_star_full((4*hs + 1): 4*(h+1), :))'/N;
    W_diag_inv = diag(diag(W_opt_inv));

    irfs_full = zeros(4*(h+1), length(alphas));
    first_time = 1;

    for m=1:length(alphas)
        if first_time 
            dynare dgptest noclearall; 
            [sim_array]=get_simul_replications(M_,options_); 
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
            first_time = 0;
        else
            set_param_value('alpha',alphas(m)); 
            [info, oo_, options_] = stoch_simul(M_, options_, oo_, var_list_);
            [sim_array]=get_simul_replications(M_,options_);
            y_sim=squeeze(sim_array(strmatch('y',M_.endo_names,'exact'),:,:));
        end
        
        simdata_alpha = sim_array([1 2],1001:(1000+T), :);
              
        m_irf_path_full = zeros(4*(h+1), 10);
        count = 1;
        j = 1;
        while count < 11
            try
            simdata_path_full = simdata_alpha(:, :, j);
            [Apathf,SIGMApathf,Upathf,Vpathf] = olsvarc(simdata_path_full', p);
            [IRFr_full]=bootirf(Apathf,Uf,v_sampledata_full',Vpathf);
            irf_path_f = vec(IRFr_full);
            m_irf_path_f(:, count) = irf_path_f;
            count = count + 1;
            catch
                count = count;
            end
            j = j+1;
        end
        mean_irf_f = sum(m_irf_path_f, 2)/10; 
        irfs_full(:, m) = mean_irf_f; 
    end
    
    dis_full = sampleirf_full((4*hs+1):4*(h+1)) - irfs_full((4*hs+1):4*(h+1), :); % dim: drop the first four responses
    dis_full_sqr = sum(dis_full.^2, 1);
    % find the min index and the corresponding phi
    est_alpha = alphas*(dis_full_sqr == min(dis_full_sqr))'
    v_est_alpha(i) = est_alpha;
    
    v_obj_1 = zeros(length(alphas), 1);
    v_obj_2 = zeros(length(alphas), 1);
    v_obj_opt_1 = zeros(length(alphas), 1);
    v_obj_opt_2 = zeros(length(alphas), 1);
    
    pick_reg_a_1 = pick_c_1/(T^(1/3));
    pick_reg_a_2 = pick_c_2/(T^(1/3));
    
    for m = 1: length(alphas)
        reg_dis_full = dis_full(:, m);
        reg_sqr_full = (phi_f' * reg_dis_full).^2; % T by 1 vector
        obj_1 = (diag(lambda_f)./(diag(lambda_f).^2 + pick_reg_a_1))' * reg_sqr_full;
        obj_2 = (1/diag(lambda_f)) * reg_sqr_full;
        v_obj_1(m) = obj_1;
        v_obj_2(m) = obj_2;
        
        reg_sqr_full_opt = (phi_f_opt' * reg_dis_full).^2; % T by 1 vector
        obj_opt_1 = (diag(lambda_f_opt)./(diag(lambda_f_opt).^2 + pick_reg_a_2))' * reg_sqr_full_opt;
        obj_opt_2 = (1/diag(lambda_f_opt)) * reg_sqr_full_opt;
        v_obj_opt_1(m) = obj_opt_1;
        v_obj_opt_2(m) = obj_opt_2;
    end
    
    est_alpha_reg = alphas*(v_obj_1 == min(v_obj_1))
    est_alpha_nonreg = alphas*(v_obj_2 == min(v_obj_2))
    est_alpha_opt_reg = alphas*(v_obj_opt_1 == min(v_obj_opt_1))
    est_alpha_opt_nonreg = alphas*(v_obj_opt_2 == min(v_obj_opt_2))

    v_est_alpha_reg(i) = est_alpha_reg;
    v_est_alpha_nonreg(i) = est_alpha_nonreg;
    v_est_alpha_opt_reg(i) = est_alpha_opt_reg;
    v_est_alpha_opt_nonreg(i) = est_alpha_opt_nonreg;
    
    dis_sqr_opt = dis_full' * (pinv(W_opt_inv)*dis_full);
    sqrnorm_opt = diag(dis_sqr_opt);
    est_alpha_opt = alphas*(sqrnorm_opt == min(sqrnorm_opt))
    v_est_alpha_opt(i) = est_alpha_opt;

    dis_sqr_diag = dis' * (W_diag_inv\dis);
    sqrnorm_diag = diag(dis_sqr_diag);
    est_alpha_diag = alphas*(sqrnorm_diag == min(sqrnorm_diag))
    v_est_alpha_diag(i) = est_alpha_diag;
    
    valid = valid +1;
    catch
        disp('sample failed')
        valid = valid;
    end
    end
    
end

% save T232p2H80_opt_3 v_est_alpha v_est_alpha_reg v_est_alpha_nonreg...
%     v_est_alpha_opt_reg v_est_alpha_opt_nonreg v_est_alpha_opt... 
%     v_est_alpha_diag v_pick_c_1 v_pick_c_2

v_est_alpha = nonzeros(v_est_alpha);
v_est_alpha_reg = nonzeros(v_est_alpha_reg);
v_est_alpha_nonreg = nonzeros(v_est_alpha_nonreg);
v_est_alpha_opt_reg = nonzeros(v_est_alpha_opt_reg);
v_est_alpha_opt_nonreg = nonzeros(v_est_alpha_opt_nonreg);
v_est_alpha_opt = nonzeros(v_est_alpha_opt);
v_est_alpha_diag = nonzeros(v_est_alpha_diag);
v_pick_c_1 = nonzeros(v_pick_c_1);
v_pick_c_2 = nonzeros(v_pick_c_2);

mid = B/2;

std_alpha_1 = std(v_est_alpha(1:mid));
std_alpha_2 = std(v_est_alpha(mid+1:B));

std_alpha_reg_1 = std(v_est_alpha_reg(1:mid));
std_alpha_reg_2 = std(v_est_alpha_reg(mid+1:B));

std_alpha_nonreg_1 = std(v_est_alpha_nonreg(1:mid));
std_alpha_nonreg_2 = std(v_est_alpha_nonreg(mid+1:B));

std_alpha_opt_reg_1 = std(v_est_alpha_opt_reg(1:mid));
std_alpha_opt_reg_2 = std(v_est_alpha_opt_reg(mid+1:B));

std_alpha_opt_nonreg_1 = std(v_est_alpha_opt_nonreg(1:mid));
std_alpha_opt_nonreg_2 = std(v_est_alpha_opt_nonreg(mid+1:B));

std_alpha_opt_1 = std(v_est_alpha_opt(1:mid));
std_alpha_opt_2 = std(v_est_alpha_opt(mid+1:B));

std_alpha_diag_1 = std(v_est_alpha_diag(1:mid));
std_alpha_diag_2 = std(v_est_alpha_diag(mid+1:B));

ncover_noweight_5 = coverage(std_alpha_2, 0.05, v_est_alpha(1:mid), true_alpha) ...
                    + coverage(std_alpha_1, 0.05, v_est_alpha(mid+1:B), true_alpha)
                
ncover_noweight_10 = coverage(std_alpha_2, 0.1, v_est_alpha(1:mid), true_alpha) ...
                    + coverage(std_alpha_1, 0.1, v_est_alpha(mid+1:B), true_alpha)

ncover_reg_5 = coverage(std_alpha_reg_2, 0.05, v_est_alpha_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_reg_1, 0.05, v_est_alpha_reg(mid+1:B), true_alpha)
                
ncover_reg_10 = coverage(std_alpha_reg_2, 0.1, v_est_alpha_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_reg_1, 0.1, v_est_alpha_reg(mid+1:B), true_alpha)
                
ncover_nonreg_5 = coverage(std_alpha_nonreg_2, 0.05, v_est_alpha_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_nonreg_1, 0.05, v_est_alpha_nonreg(mid+1:B), true_alpha)
                
ncover_nonreg_10 = coverage(std_alpha_nonreg_2, 0.1, v_est_alpha_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_nonreg_1, 0.1, v_est_alpha_nonreg(mid+1:B), true_alpha)

ncover_opt_reg_5 = coverage(std_alpha_opt_reg_2, 0.05, v_est_alpha_opt_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_reg_1, 0.05, v_est_alpha_opt_reg(mid+1:B), true_alpha)
                
ncover_opt_reg_10 = coverage(std_alpha_opt_reg_2, 0.1, v_est_alpha_opt_reg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_reg_1, 0.1, v_est_alpha_opt_reg(mid+1:B), true_alpha)
                
ncover_opt_nonreg_5 = coverage(std_alpha_opt_nonreg_2, 0.05, v_est_alpha_opt_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_nonreg_1, 0.05, v_est_alpha_opt_nonreg(mid+1:B), true_alpha)
                
ncover_opt_nonreg_10 = coverage(std_alpha_opt_nonreg_2, 0.1, v_est_alpha_opt_nonreg(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_nonreg_1, 0.1, v_est_alpha_opt_nonreg(mid+1:B), true_alpha)

ncover_opt_5 = coverage(std_alpha_opt_2, 0.05, v_est_alpha_opt(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_1, 0.05, v_est_alpha_opt(mid+1:B), true_alpha)
                
ncover_opt_10 = coverage(std_alpha_opt_2, 0.1, v_est_alpha_opt(1:mid), true_alpha) ...
                    + coverage(std_alpha_opt_1, 0.1, v_est_alpha_opt(mid+1:B), true_alpha)
                
ncover_diag_5 = coverage(std_alpha_diag_2, 0.05, v_est_alpha_diag(1:mid), true_alpha) ...
                    + coverage(std_alpha_diag_1, 0.05, v_est_alpha_diag(mid+1:B), true_alpha)
                
ncover_diag_10 = coverage(std_alpha_diag_2, 0.1, v_est_alpha_diag(1:mid), true_alpha) ...
                    + coverage(std_alpha_diag_1, 0.1, v_est_alpha_diag(mid+1:B), true_alpha)

mean_est_alpha = mean(v_est_alpha);
mean_est_alpha_reg = mean(v_est_alpha_reg);
mean_est_alpha_nonreg = mean(v_est_alpha_nonreg);
mean_est_alpha_opt_reg = mean(v_est_alpha_opt_reg);
mean_est_alpha_opt_nonreg = mean(v_est_alpha_opt_nonreg);
mean_est_alpha_opt = mean(v_est_alpha_opt);
mean_est_alpha_diag = mean(v_est_alpha_diag);
sd_est_alpha = std(v_est_alpha);
sd_est_alpha_reg = std(v_est_alpha_reg);
sd_est_alpha_nonreg = std(v_est_alpha_nonreg);
sd_est_alpha_opt_reg = std(v_est_alpha_opt_reg);
sd_est_alpha_opt_nonreg = std(v_est_alpha_opt_nonreg);
sd_est_alpha_opt = std(v_est_alpha_opt);
sd_est_alpha_diag = std(v_est_alpha_diag);
                
save T232p2H20_opt v_est_alpha v_est_alpha_reg v_est_alpha_nonreg...
    v_est_alpha_opt_reg v_est_alpha_opt_nonreg v_est_alpha_opt... 
    v_est_alpha_diag mean_est_alpha mean_est_alpha_reg mean_est_alpha_nonreg...
    mean_est_alpha_opt_reg mean_est_alpha_opt_nonreg...
    mean_est_alpha_opt mean_est_alpha_diag sd_est_alpha sd_est_alpha_reg...
    sd_est_alpha_nonreg sd_est_alpha_opt_reg sd_est_alpha_opt_nonreg...
    sd_est_alpha_opt sd_est_alpha_diag ncover_noweight_5... 
    ncover_noweight_10 ncover_reg_5 ncover_reg_10 ncover_nonreg_5 ...
    ncover_nonreg_10 ncover_opt_reg_5 ncover_opt_reg_10...
    ncover_opt_nonreg_5 ncover_opt_nonreg_10...
    ncover_opt_5 ncover_opt_10 ncover_diag_5 ncover_diag_10...
    v_pick_c_1 v_pick_c_2